/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull.operators;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.execution.pull.operators.DataSourceOperator;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.Row;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.KeyConstraint;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyedTableLookupOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator,
DataSourceOperator {
    private static final Logger LOG = LogManager.getLogger(KeyedTableLookupOperator.class);
    private final Materialization mat;
    private final DataSourceNode logicalNode;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private ImmutableList<Locator.KsqlPartitionLocation> partitionLocations;
    private Iterator<Row> resultIterator;
    private Iterator<Locator.KsqlKey> keyIterator;
    private Iterator<Locator.KsqlPartitionLocation> partitionLocationIterator;
    private Locator.KsqlPartitionLocation nextLocation;
    private Locator.KsqlKey nextKey;
    private long returnedRows = 0L;

    public KeyedTableLookupOperator(Materialization mat, DataSourceNode logicalNode, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.mat = Objects.requireNonNull(mat, "mat");
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.consistencyOffsetVector = Objects.requireNonNull(consistencyOffsetVector, "consistencyOffsetVector");
    }

    @Override
    public void open() {
        this.partitionLocationIterator = this.partitionLocations.iterator();
        if (this.partitionLocationIterator.hasNext()) {
            this.nextLocation = this.partitionLocationIterator.next();
            if (!this.nextLocation.getKeys().isPresent()) {
                throw new IllegalStateException("Table lookup queries should be done with keys");
            }
            this.keyIterator = ((Set)this.nextLocation.getKeys().get()).stream().iterator();
            if (this.keyIterator.hasNext()) {
                this.nextKey = this.keyIterator.next();
                this.resultIterator = this.getMatIterator(this.nextKey);
            }
        }
    }

    @Override
    public Object next() {
        while (!this.resultIterator.hasNext()) {
            if (!this.keyIterator.hasNext()) {
                if (!this.partitionLocationIterator.hasNext()) {
                    return null;
                }
                this.nextLocation = this.partitionLocationIterator.next();
                if (!this.nextLocation.getKeys().isPresent()) {
                    throw new IllegalStateException("Table lookup queries should be done with keys");
                }
                this.keyIterator = ((Set)this.nextLocation.getKeys().get()).stream().iterator();
            }
            this.nextKey = this.keyIterator.next();
            this.resultIterator = this.getMatIterator(this.nextKey);
        }
        ++this.returnedRows;
        Row row = this.resultIterator.next();
        return QueryRowImpl.of(row.schema(), row.key(), row.window(), row.value(), row.rowTime());
    }

    private Iterator<Row> getMatIterator(Locator.KsqlKey ksqlKey) {
        Iterator result;
        if (!(this.nextKey instanceof KeyConstraint)) {
            throw new IllegalStateException(String.format("Keyed lookup queries should be done with key constraints: %s", ksqlKey.toString()));
        }
        KeyConstraint keyConstraintKey = (KeyConstraint)ksqlKey;
        if (keyConstraintKey.getOperator() == KeyConstraint.ConstraintOperator.EQUAL) {
            result = this.mat.nonWindowed().get(ksqlKey.getKey(), this.nextLocation.getPartition(), this.consistencyOffsetVector);
        } else if (keyConstraintKey.getOperator() == KeyConstraint.ConstraintOperator.GREATER_THAN || keyConstraintKey.getOperator() == KeyConstraint.ConstraintOperator.GREATER_THAN_OR_EQUAL) {
            GenericKey fromKey = keyConstraintKey.getKey();
            GenericKey toKey = null;
            result = this.mat.nonWindowed().get(this.nextLocation.getPartition(), fromKey, toKey, this.consistencyOffsetVector);
        } else if (keyConstraintKey.getOperator() == KeyConstraint.ConstraintOperator.LESS_THAN || keyConstraintKey.getOperator() == KeyConstraint.ConstraintOperator.LESS_THAN_OR_EQUAL) {
            GenericKey fromKey = null;
            GenericKey toKey = keyConstraintKey.getKey();
            result = this.mat.nonWindowed().get(this.nextLocation.getPartition(), fromKey, toKey, this.consistencyOffsetVector);
        } else {
            throw new IllegalStateException(String.format("Invalid comparator type " + String.valueOf((Object)keyConstraintKey.getOperator()), new Object[0]));
        }
        return result;
    }

    @Override
    public void close() {
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    public void addChild(AbstractPhysicalOperator child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPhysicalOperator getChild() {
        return null;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        return null;
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="partitionLocations is ImmutableList")
    public List<Locator.KsqlPartitionLocation> getPartitionLocations() {
        return this.partitionLocations;
    }

    @Override
    public void setPartitionLocations(List<Locator.KsqlPartitionLocation> locations) {
        Objects.requireNonNull(locations, "locations");
        this.partitionLocations = ImmutableList.copyOf(locations);
    }

    @Override
    public long getReturnedRowCount() {
        return this.returnedRows;
    }
}

