/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.Window;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Windowed;

public final class RowUtil {
    private RowUtil() {
    }

    public static QueryRow createRow(Object key, GenericRow value, long timestamp, boolean windowed, LogicalSchema logicalSchema) {
        if (!windowed) {
            GenericKey keyCopy = GenericKey.fromList(key != null ? ((GenericKey)key).values() : Collections.emptyList());
            GenericRow valueCopy = GenericRow.fromList((List)value.values());
            return QueryRowImpl.of(logicalSchema, keyCopy, Optional.empty(), valueCopy, timestamp);
        }
        Windowed windowedKey = (Windowed)key;
        GenericKey keyCopy = GenericKey.fromList((List)((GenericKey)windowedKey.key()).values());
        GenericRow valueCopy = GenericRow.fromList((List)value.values());
        return QueryRowImpl.of(logicalSchema, keyCopy, Optional.of(Window.of((Instant)windowedKey.window().startTime(), (Instant)windowedKey.window().endTime())), valueCopy, timestamp);
    }
}

