/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.operators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.scalablepush.ProcessingQueue;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.scalablepush.operators.PushDataSourceOperator;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.query.QueryId;
import java.util.List;
import java.util.Optional;

public class PeekStreamOperator
extends AbstractPhysicalOperator
implements PushDataSourceOperator {
    private final DataSourceNode logicalNode;
    private final ScalablePushRegistry scalablePushRegistry;
    private final ProcessingQueue processingQueue;
    private final Optional<ScalablePushRegistry.CatchupMetadata> catchupMetadata;
    private long rowsRead = 0L;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PeekStreamOperator(ScalablePushRegistry scalablePushRegistry, DataSourceNode logicalNode, QueryId queryId, Optional<ScalablePushRegistry.CatchupMetadata> catchupMetadata) {
        this.scalablePushRegistry = scalablePushRegistry;
        this.logicalNode = logicalNode;
        this.processingQueue = new ProcessingQueue(queryId);
        this.catchupMetadata = catchupMetadata;
    }

    @Override
    public void open() {
        this.scalablePushRegistry.register(this.processingQueue, this.catchupMetadata);
    }

    @Override
    public Object next() {
        ++this.rowsRead;
        return this.processingQueue.poll();
    }

    @Override
    public void close() {
        this.processingQueue.close();
        this.scalablePushRegistry.unregister(this.processingQueue);
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    public void addChild(AbstractPhysicalOperator child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        return null;
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="scalablePushRegistry is meant to be exposed")
    public ScalablePushRegistry getScalablePushRegistry() {
        return this.scalablePushRegistry;
    }

    @Override
    public void setNewRowCallback(Runnable newRowCallback) {
        this.processingQueue.setNewRowCallback(newRowCallback);
    }

    @Override
    public boolean droppedRows() {
        return this.processingQueue.hasDroppedRows();
    }

    @Override
    public boolean hasError() {
        return this.processingQueue.getHasError();
    }

    @Override
    public long getRowsReadCount() {
        return this.rowsRead;
    }
}

