/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Blacklist
implements Predicate<String> {
    private static final Logger logger = LogManager.getLogger(Blacklist.class);
    private static final String BLACKLIST_NONE = "";
    private static final String BLACKLIST_PREFIX = "^(?:";
    private static final String BLACKLIST_SUFFIX = ")\\.?.*$";
    private String blackList = "";

    Blacklist(File inputFile) {
        if (!inputFile.exists()) {
            logger.info("Blacklist file: {} not found. No classes will be blacklisted", (Object)inputFile);
            return;
        }
        try {
            this.blackList = Files.readLines((File)inputFile, (Charset)Charset.forName(StandardCharsets.UTF_8.name())).stream().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).map(line -> line.replaceAll("\\.", "\\\\.")).collect(Collectors.joining("|", BLACKLIST_PREFIX, BLACKLIST_SUFFIX));
            if (this.blackList.equals("^(?:)\\.?.*$")) {
                this.blackList = BLACKLIST_NONE;
            }
            logger.info("Setting UDF blacklisted classes to: " + this.blackList);
        }
        catch (IOException e) {
            logger.warn("Failed to load resource blacklist from {} no classes will be blacklisted", (Object)inputFile);
        }
    }

    @Override
    public boolean test(String resourceName) {
        return resourceName.matches(this.blackList);
    }
}

