/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.udf.Kudf;
import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;

class UdfMetricProducer
implements Kudf {
    private final Sensor sensor;
    private final Kudf kudf;
    private final Time time;

    UdfMetricProducer(Sensor sensor, Kudf kudf, Time time) {
        this.sensor = Objects.requireNonNull(sensor, "sensor can't be null");
        this.kudf = Objects.requireNonNull(kudf, "kudf can't be null");
        this.time = Objects.requireNonNull(time, "time can't be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object ... args) {
        long start = this.time.nanoseconds();
        try {
            Object object = this.kudf.evaluate(args);
            return object;
        }
        finally {
            this.sensor.record((double)(this.time.nanoseconds() - start));
        }
    }
}

