/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.Blacklist;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.UdafLoader;
import io.confluent.ksql.function.UdfClassLoader;
import io.confluent.ksql.function.UdfLoader;
import io.confluent.ksql.function.UdtfLoader;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udtf.UdtfDescription;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.security.ExtensionSecurityManager;
import io.confluent.ksql.util.KsqlConfig;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserFunctionLoader {
    private static final Logger LOGGER = LogManager.getLogger(UserFunctionLoader.class);
    private final File pluginDir;
    private final ClassLoader parentClassLoader;
    private final Predicate<String> blacklist;
    private final boolean loadCustomerUdfs;
    private final UdfLoader udfLoader;
    private final UdafLoader udafLoader;
    private final UdtfLoader udtfLoader;

    public UserFunctionLoader(MutableFunctionRegistry functionRegistry, File pluginDir, ClassLoader parentClassLoader, Predicate<String> blacklist, Optional<Metrics> metrics, boolean loadCustomerUdfs) {
        Objects.requireNonNull(functionRegistry, "functionRegistry can't be null");
        this.pluginDir = Objects.requireNonNull(pluginDir, "pluginDir can't be null");
        this.parentClassLoader = Objects.requireNonNull(parentClassLoader, "parentClassLoader can't be null");
        this.blacklist = Objects.requireNonNull(blacklist, "blacklist can't be null");
        this.loadCustomerUdfs = loadCustomerUdfs;
        SqlTypeParser typeParser = SqlTypeParser.create((TypeRegistry)TypeRegistry.EMPTY);
        this.udfLoader = new UdfLoader(functionRegistry, metrics, typeParser, false);
        this.udafLoader = new UdafLoader(functionRegistry, metrics, typeParser);
        this.udtfLoader = new UdtfLoader(functionRegistry, metrics, typeParser, false);
    }

    public void load() {
        this.loadFunctions(this.parentClassLoader, Optional.empty());
        if (this.loadCustomerUdfs) {
            try {
                if (!this.pluginDir.exists() && !this.pluginDir.isDirectory()) {
                    LOGGER.info("UDFs can't be loaded as as dir {} doesn't exist or is not a directory", (Object)this.pluginDir);
                    return;
                }
                Files.find(this.pluginDir.toPath(), 1, (path, attributes) -> path.toString().endsWith(".jar"), new FileVisitOption[0]).map(path -> UdfClassLoader.newClassLoader(path, this.parentClassLoader, this.blacklist)).forEach(classLoader -> this.loadFunctions((ClassLoader)classLoader, Optional.of(classLoader.getJarPath())));
            }
            catch (IOException e) {
                LOGGER.error("Failed to load UDFs from location {}", (Object)this.pluginDir, (Object)e);
            }
        }
    }

    private void loadFunctions(ClassLoader loader, Optional<Path> path) {
        String pathLoadedFrom = path.map(Path::toString).orElse("internal");
        ClassGraph classGraph = new ClassGraph();
        if (loader != this.parentClassLoader) {
            classGraph.overrideClassLoaders(new ClassLoader[]{loader});
        }
        try (ScanResult scan = classGraph.enableAnnotationInfo().ignoreParentClassLoaders().filterClasspathElements(this.ksqlEngineFilter(loader)).scan();){
            for (ClassInfo udf : scan.getClassesWithAnnotation(UdfDescription.class.getName())) {
                this.udfLoader.loadUdfFromClass(udf.loadClass(), pathLoadedFrom);
            }
            for (ClassInfo udaf : scan.getClassesWithAnnotation(UdafDescription.class.getName())) {
                this.udafLoader.loadUdafFromClass(udaf.loadClass(), pathLoadedFrom);
            }
            for (ClassInfo udtf : scan.getClassesWithAnnotation(UdtfDescription.class.getName())) {
                this.udtfLoader.loadUdtfFromClass(udtf.loadClass(), pathLoadedFrom);
            }
        }
    }

    private ClassGraph.ClasspathElementFilter ksqlEngineFilter(ClassLoader loader) {
        return name -> this.parentClassLoader != loader || name.contains("ksqldb-rest-app") || name.contains("ksqldb-engine");
    }

    public static UserFunctionLoader newInstance(KsqlConfig config, MutableFunctionRegistry metaStore, String ksqlInstallDir, Metrics metricsRegistry) {
        Optional<Metrics> metrics;
        boolean loadCustomerUdfs = config.getBoolean("ksql.udfs.enabled");
        boolean collectMetrics = config.getBoolean("ksql.udf.collect.metrics");
        String extDirName = config.getString("ksql.extension.dir");
        File pluginDir = "ext".equals(extDirName) ? new File(ksqlInstallDir, extDirName) : new File(extDirName);
        Optional<Object> optional = metrics = collectMetrics ? Optional.of(metricsRegistry) : Optional.empty();
        if (config.getBoolean("ksql.udf.enable.security.manager").booleanValue()) {
            System.setSecurityManager(ExtensionSecurityManager.INSTANCE);
        }
        return new UserFunctionLoader(metaStore, pluginDir, Thread.currentThread().getContextClassLoader(), new Blacklist(new File(pluginDir, "resource-blacklist.txt")), metrics, loadCustomerUdfs);
    }
}

