/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf;

import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public abstract class BaseComparableKudaf<T extends Comparable<? super T>>
implements Udaf<T, T, T> {
    private final BiFunction<T, T, T> aggregatePrimitive;
    private SqlType inputSchema;

    public BaseComparableKudaf(BiFunction<T, T, T> aggregatePrimitive) {
        this.aggregatePrimitive = Objects.requireNonNull(aggregatePrimitive, "aggregatePrimitive");
    }

    public void initializeTypeArguments(List<SqlArgument> argTypeList) {
        this.inputSchema = argTypeList.get(0).getSqlTypeOrThrow();
    }

    public Optional<SqlType> getAggregateSqlType() {
        return Optional.of(this.inputSchema);
    }

    public Optional<SqlType> getReturnSqlType() {
        return Optional.of(this.inputSchema);
    }

    public T initialize() {
        return null;
    }

    public T aggregate(T current, T aggregate) {
        if (current == null) {
            return aggregate;
        }
        if (aggregate == null) {
            return current;
        }
        return (T)((Comparable)this.aggregatePrimitive.apply(current, aggregate));
    }

    public T merge(T aggOne, T aggTwo) {
        return this.aggregate(aggOne, aggTwo);
    }

    public T map(T agg) {
        return agg;
    }
}

