/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.array;

import com.google.common.collect.Lists;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Configurable;

@UdafDescription(name="collect_set", description="Gather all of the distinct values from an input grouping into a single Array.\nNot available for aggregating values from an input Table.\nYou may limit the size of the resultant Array to N entries, beyond which any further values will be silently ignored, by setting the ksql.functions.collect_list.limit configuration to N.", author="Confluent")
public final class CollectSetUdaf {
    public static final String LIMIT_CONFIG = "ksql.functions.collect_set.limit";

    private CollectSetUdaf() {
    }

    @UdafFactory(description="collect distinct values of a Bigint field into a single Array")
    public static <T> Udaf<T, List<T>, List<T>> createCollectSetT() {
        return new Collect();
    }

    private static final class Collect<T>
    implements Udaf<T, List<T>, List<T>>,
    Configurable {
        private int limit = Integer.MAX_VALUE;
        SqlType inputType;

        private Collect() {
        }

        public void configure(Map<String, ?> map) {
            Object limit = map.get(CollectSetUdaf.LIMIT_CONFIG);
            if (limit != null) {
                if (limit instanceof Number) {
                    this.limit = ((Number)limit).intValue();
                } else if (limit instanceof String) {
                    this.limit = Integer.parseInt((String)limit);
                }
            }
            if (this.limit < 0) {
                this.limit = Integer.MAX_VALUE;
            }
        }

        public void initializeTypeArguments(List<SqlArgument> argTypeList) {
            this.inputType = argTypeList.get(0).getSqlTypeOrThrow();
        }

        public Optional<SqlType> getAggregateSqlType() {
            return Optional.of(SqlArray.of((SqlType)this.inputType));
        }

        public Optional<SqlType> getReturnSqlType() {
            return Optional.of(SqlArray.of((SqlType)this.inputType));
        }

        public List<T> initialize() {
            return Lists.newArrayList();
        }

        public List<T> aggregate(T thisValue, List<T> aggregate) {
            if (aggregate.size() < this.limit && !aggregate.contains(thisValue)) {
                aggregate.add(thisValue);
            }
            return aggregate;
        }

        public List<T> merge(List<T> aggOne, List<T> aggTwo) {
            for (T thisEntry : aggTwo) {
                if (aggOne.size() == this.limit) break;
                if (aggOne.contains(thisEntry)) continue;
                aggOne.add(thisEntry);
            }
            return aggOne;
        }

        public List<T> map(List<T> agg) {
            return agg;
        }
    }
}

