/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.average;

import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import java.util.function.BiFunction;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

@UdafDescription(name="avg", description="Returns the average value of the column computed as the sum divided by thecount. Applicable only to numeric types.", author="Confluent")
public final class AverageUdaf {
    private static final String COUNT = "COUNT";
    private static final String SUM = "SUM";
    private static final Schema STRUCT_LONG = SchemaBuilder.struct().optional().field("SUM", Schema.OPTIONAL_INT64_SCHEMA).field("COUNT", Schema.OPTIONAL_INT64_SCHEMA).build();
    private static final Schema STRUCT_INT = SchemaBuilder.struct().optional().field("SUM", Schema.OPTIONAL_INT32_SCHEMA).field("COUNT", Schema.OPTIONAL_INT64_SCHEMA).build();
    private static final Schema STRUCT_DOUBLE = SchemaBuilder.struct().optional().field("SUM", Schema.OPTIONAL_FLOAT64_SCHEMA).field("COUNT", Schema.OPTIONAL_INT64_SCHEMA).build();

    private AverageUdaf() {
    }

    @UdafFactory(description="Compute average of column with type Long.", aggregateSchema="STRUCT<SUM bigint, COUNT bigint>")
    public static TableUdaf<Long, Struct, Double> averageLong() {
        return AverageUdaf.getAverageImplementation(0L, STRUCT_LONG, (sum, newValue) -> sum.getInt64(SUM) + newValue, (sum, count) -> (double)sum.getInt64(SUM).longValue() / count, (sum1, sum2) -> sum1.getInt64(SUM) + sum2.getInt64(SUM), (sum, valueToUndo) -> sum.getInt64(SUM) - valueToUndo);
    }

    @UdafFactory(description="Compute average of column with type Integer.", aggregateSchema="STRUCT<SUM integer, COUNT bigint>")
    public static TableUdaf<Integer, Struct, Double> averageInt() {
        return AverageUdaf.getAverageImplementation(0, STRUCT_INT, (sum, newValue) -> sum.getInt32(SUM) + newValue, (sum, count) -> (double)sum.getInt32(SUM).intValue() / count, (sum1, sum2) -> sum1.getInt32(SUM) + sum2.getInt32(SUM), (sum, valueToUndo) -> sum.getInt32(SUM) - valueToUndo);
    }

    @UdafFactory(description="Compute average of column with type Double.", aggregateSchema="STRUCT<SUM double, COUNT bigint>")
    public static TableUdaf<Double, Struct, Double> averageDouble() {
        return AverageUdaf.getAverageImplementation(0.0, STRUCT_DOUBLE, (sum, newValue) -> sum.getFloat64(SUM) + newValue, (sum, count) -> sum.getFloat64(SUM) / count, (sum1, sum2) -> sum1.getFloat64(SUM) + sum2.getFloat64(SUM), (sum, valueToUndo) -> sum.getFloat64(SUM) - valueToUndo);
    }

    private static <I> TableUdaf<I, Struct, Double> getAverageImplementation(final I initialValue, final Schema structSchema, final BiFunction<Struct, I, I> adder, final BiFunction<Struct, Double, Double> mapper, final BiFunction<Struct, Struct, I> merger, final BiFunction<Struct, I, I> subtracter) {
        return new TableUdaf<I, Struct, Double>(){

            public Struct initialize() {
                return new Struct(structSchema).put(AverageUdaf.SUM, initialValue).put(AverageUdaf.COUNT, (Object)0L);
            }

            public Struct aggregate(I newValue, Struct aggregate) {
                if (newValue == null) {
                    return aggregate;
                }
                return new Struct(structSchema).put(AverageUdaf.SUM, adder.apply(aggregate, newValue)).put(AverageUdaf.COUNT, (Object)(aggregate.getInt64(AverageUdaf.COUNT) + 1L));
            }

            public Double map(Struct aggregate) {
                long count = aggregate.getInt64(AverageUdaf.COUNT);
                if (count == 0L) {
                    return 0.0;
                }
                return (Double)mapper.apply(aggregate, Double.valueOf(count));
            }

            public Struct merge(Struct agg1, Struct agg2) {
                return new Struct(structSchema).put(AverageUdaf.SUM, merger.apply(agg1, agg2)).put(AverageUdaf.COUNT, (Object)(agg1.getInt64(AverageUdaf.COUNT) + agg2.getInt64(AverageUdaf.COUNT)));
            }

            public Struct undo(I valueToUndo, Struct aggregate) {
                if (valueToUndo == null) {
                    return aggregate;
                }
                return new Struct(structSchema).put(AverageUdaf.SUM, subtracter.apply(aggregate, valueToUndo)).put(AverageUdaf.COUNT, (Object)(aggregate.getInt64(AverageUdaf.COUNT) - 1L));
            }
        };
    }
}

