/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.count;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.cardinality.RegisterSet;
import com.google.common.primitives.Ints;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import java.util.List;

@UdafDescription(name="COUNT_DISTINCT", description="This function returns the number of items found in a group. The implementation is probabilistic with a typical accuracy (standard error) of less than 1%.", author="Confluent")
public final class CountDistinct {
    static final String DESCRIPTION = "This function returns the number of items found in a group. The implementation is probabilistic with a typical accuracy (standard error) of less than 1%.";
    private static final int M = 16384;
    private static final int LOG_2_M = 14;

    private CountDistinct() {
    }

    private static <T> Udaf<T, List<Integer>, Long> countDistinct() {
        return new Udaf<T, List<Integer>, Long>(){

            public List<Integer> initialize() {
                return Ints.asList((int[])new int[RegisterSet.getSizeForCount((int)16384)]);
            }

            public List<Integer> aggregate(T current, List<Integer> aggregate) {
                if (current == null) {
                    return aggregate;
                }
                int[] ints = Ints.toArray(aggregate);
                RegisterSet set = new RegisterSet(16384, ints);
                CountDistinct.toHyperLogLog(set).offer(current);
                return Ints.asList((int[])ints);
            }

            public List<Integer> merge(List<Integer> aggOne, List<Integer> aggTwo) {
                RegisterSet registerSet = new RegisterSet(16384, Ints.toArray(aggOne));
                registerSet.merge(new RegisterSet(16384, Ints.toArray(aggTwo)));
                return Ints.asList((int[])registerSet.bits());
            }

            public Long map(List<Integer> agg) {
                return CountDistinct.toHyperLogLog(new RegisterSet(16384, Ints.toArray(agg))).cardinality();
            }
        };
    }

    private static HyperLogLog toHyperLogLog(RegisterSet set) {
        return new HyperLogLog(14, set);
    }

    @UdafFactory(description="Count distinct")
    public static <T> Udaf<T, List<Integer>, Long> distinct() {
        return CountDistinct.countDistinct();
    }
}

