/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.map;

import com.google.common.collect.Maps;
import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import java.util.Map;

@UdafDescription(name="histogram", description="Returns a map of each distinct String from the input Stream or Table and how many times each occurs. \nThis version limits the size of the resultant Map to 1000 entries. Any entries added beyond this limit will be ignored.", author="Confluent")
public final class HistogramUdaf {
    private static final int LIMIT = 1000;

    private HistogramUdaf() {
    }

    private static <T> TableUdaf<T, Map<T, Long>, Map<T, Long>> histogram() {
        return new TableUdaf<T, Map<T, Long>, Map<T, Long>>(){

            public Map<T, Long> initialize() {
                return Maps.newHashMap();
            }

            public Map<T, Long> aggregate(T current, Map<T, Long> aggregate) {
                if (aggregate.size() < 1000 || aggregate.containsKey(current)) {
                    aggregate.merge(current, 1L, Long::sum);
                }
                return aggregate;
            }

            public Map<T, Long> merge(Map<T, Long> agg1, Map<T, Long> agg2) {
                agg2.forEach((k, v) -> {
                    if (agg1.size() < 1000 || agg1.containsKey(k)) {
                        agg1.merge((Object)k, (Long)v, Long::sum);
                    }
                });
                return agg1;
            }

            public Map<T, Long> undo(T valueToUndo, Map<T, Long> aggregate) {
                aggregate.compute(valueToUndo, (k, v) -> (v = Long.valueOf(v - 1L)) < 1L ? null : v);
                return aggregate;
            }

            public Map<T, Long> map(Map<T, Long> aggregate) {
                return aggregate;
            }
        };
    }

    @UdafFactory(description="Build a value-to-count histogram of input Strings")
    public static TableUdaf<String, Map<String, Long>, Map<String, Long>> histogramString() {
        return HistogramUdaf.histogram();
    }
}

