/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.offset;

import io.confluent.ksql.serde.connect.ConnectKsqlSchemaTranslator;
import java.util.Comparator;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

final class KudafByOffsetUtils {
    static final String SEQ_FIELD = "SEQ";
    public static final String VAL_FIELD = "VAL";
    static final Schema STRUCT_INTEGER = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_INT32_SCHEMA).build();
    static final Schema STRUCT_LONG = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_INT64_SCHEMA).build();
    static final Schema STRUCT_DOUBLE = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_FLOAT64_SCHEMA).build();
    static final Schema STRUCT_BOOLEAN = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    static final Schema STRUCT_STRING = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_STRING_SCHEMA).build();
    static final Schema STRUCT_TIMESTAMP = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", ConnectKsqlSchemaTranslator.OPTIONAL_TIMESTAMP_SCHEMA).build();
    static final Schema STRUCT_TIME = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", ConnectKsqlSchemaTranslator.OPTIONAL_TIME_SCHEMA).build();
    static final Schema STRUCT_DATE = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", ConnectKsqlSchemaTranslator.OPTIONAL_DATE_SCHEMA).build();
    static final Schema STRUCT_BYTES = SchemaBuilder.struct().optional().field("SEQ", Schema.OPTIONAL_INT64_SCHEMA).field("VAL", Schema.OPTIONAL_BYTES_SCHEMA).build();
    static final Comparator<Struct> INTERMEDIATE_STRUCT_COMPARATOR = (struct1, struct2) -> {
        long sequence1 = struct1.getInt64(SEQ_FIELD);
        long sequence2 = struct2.getInt64(SEQ_FIELD);
        if (sequence1 < 0L && sequence2 >= 0L) {
            return 1;
        }
        if (sequence2 < 0L && sequence1 >= 0L) {
            return -1;
        }
        return Long.compare(sequence1, sequence2);
    };
    static final Comparator<Struct> INTERMEDIATE_STRUCT_COMPARATOR_IGNORE_NULLS = (struct1, struct2) -> {
        if (struct1.get(VAL_FIELD) == null && struct2.get(VAL_FIELD) == null) {
            return 0;
        }
        if (struct1.get(VAL_FIELD) == null) {
            return -1;
        }
        if (struct2.get(VAL_FIELD) == null) {
            return 1;
        }
        return INTERMEDIATE_STRUCT_COMPARATOR.compare((Struct)struct1, (Struct)struct2);
    };

    static Schema buildSchema(Schema schema) {
        return SchemaBuilder.struct().optional().field(SEQ_FIELD, Schema.OPTIONAL_INT64_SCHEMA).field(VAL_FIELD, schema).build();
    }

    static <T> Struct createStruct(Schema schema, long sequence, T val) {
        Struct struct = new Struct(schema);
        struct.put(SEQ_FIELD, (Object)sequence);
        struct.put(VAL_FIELD, val);
        return struct;
    }

    private KudafByOffsetUtils() {
    }
}

