/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.ArrayList;
import java.util.List;

@UdfDescription(name="array_concat", category="ARRAY", description="Concatenates two arrays, creating an array that contains all the elements in the first array followed by all the elements in the second array. Returns NULL if both input arrays are NULL. If only one argument is NULL, the result is the other argument. The two arrays must be of the same type.")
public class ArrayConcat {
    @Udf
    public <T> List<T> concat(@UdfParameter(description="First array of values") List<T> left, @UdfParameter(description="Second array of values") List<T> right) {
        if (left == null && right == null) {
            return null;
        }
        int leftSize = left != null ? left.size() : 0;
        int rightSize = right != null ? right.size() : 0;
        ArrayList<T> result = new ArrayList<T>(leftSize + rightSize);
        if (left != null) {
            result.addAll(left);
        }
        if (right != null) {
            result.addAll(right);
        }
        return result;
    }
}

