/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import com.google.common.collect.Sets;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

@UdfDescription(name="array_distinct", category="ARRAY", description="Returns an array of all the distinct values, including NULL if present, from the input array. The output array elements will be in order of their first occurrence in the input. Returns NULL if the input array is NULL.")
public class ArrayDistinct {
    @Udf
    public <T> List<T> distinct(@UdfParameter(description="Array of values to distinct") List<T> input) {
        if (input == null) {
            return null;
        }
        LinkedHashSet distinctVals = Sets.newLinkedHashSetWithExpectedSize((int)input.size());
        distinctVals.addAll(input);
        return new ArrayList(distinctVals);
    }
}

