/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.LinkedHashSet;
import java.util.List;

@UdfDescription(name="array_intersect", category="ARRAY", description="Returns an array of all the distinct elements from the intersection of both input arrays, or NULL if either input array is NULL. The order of entries in the output is the same as in the first input array.")
public class ArrayIntersect {
    @Udf
    public <T> List<T> intersect(@UdfParameter(description="First array of values") List<T> left, @UdfParameter(description="Second array of values") List<T> right) {
        if (left == null || right == null) {
            return null;
        }
        LinkedHashSet intersection = Sets.newLinkedHashSet(left);
        intersection.retainAll(Sets.newHashSet(right));
        return Lists.newArrayList((Iterable)intersection);
    }
}

