/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.conversions;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@UdfDescription(name="bigint_from_bytes", category="CONVERSIONS", description="Converts a BYTES value to an BIGINT value according to the specified byte order. BYTES must be 8 bytes long or a NULL value will be returned.", author="Confluent")
public class BigIntFromBytes {
    private static final int BYTES_LENGTH = 8;

    @Udf(description="Converts a BYTES value to an BIGINT value using the 'BIG_ENDIAN' byte order. BYTES must be 8 bytes long or a NULL value will be returned.")
    public Long bigIntFromBytes(@UdfParameter(description="The BYTES value to convert.") ByteBuffer value) {
        return this.bigIntFromBytes(value, ByteOrder.BIG_ENDIAN);
    }

    @Udf(description="Converts a BYTES value to an BIGINT value according to the specified byte order. BYTES must be 8 bytes long or a NULL value will be returned.")
    public Long bigIntFromBytes(@UdfParameter(description="The BYTES value to convert.") ByteBuffer value, @UdfParameter(description="The byte order. Valid orders are 'BIG_ENDIAN' and 'LITTLE_ENDIAN'. If omitted, 'BIG_ENDIAN' is used.") String byteOrder) {
        return this.bigIntFromBytes(value, BytesUtils.byteOrderType((String)byteOrder));
    }

    private Long bigIntFromBytes(ByteBuffer value, ByteOrder byteOrder) {
        if (value == null) {
            return null;
        }
        BytesUtils.checkBytesSize((ByteBuffer)value, (int)8);
        value.rewind();
        return value.order(byteOrder).getLong();
    }
}

