/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Date;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="dateadd", category="DATE / TIME", author="Confluent", description="Adds a duration to a DATE value.")
public class DateAdd {
    @Udf(description="Adds a duration to a date")
    public Date dateAdd(@UdfParameter(description="A unit of time, for example DAY") TimeUnit unit, @UdfParameter(description="An integer number of intervals to add") Integer interval, @UdfParameter(description="A DATE value.") Date date) {
        if (unit == null || interval == null || date == null) {
            return null;
        }
        long epochDayResult = TimeUnit.MILLISECONDS.toDays(date.getTime() + unit.toMillis(interval.intValue()));
        return new Date(TimeUnit.DAYS.toMillis(epochDayResult));
    }
}

