/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="timestampsub", category="DATE / TIME", author="Confluent", description="Subtracts a duration from a TIMESTAMP value.")
public class TimestampSub {
    @Udf(description="Subtracts a duration from a timestamp")
    public Timestamp timestampSub(@UdfParameter(description="A unit of time, for example DAY or HOUR") TimeUnit unit, @UdfParameter(description="An integer number of intervals to subtract") Integer interval, @UdfParameter(description="A TIMESTAMP value.") Timestamp timestamp) {
        if (unit == null || interval == null || timestamp == null) {
            return null;
        }
        return new Timestamp(timestamp.getTime() - unit.toMillis(interval.intValue()));
    }
}

