/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import java.util.ArrayList;

@UdfDescription(name="JSON_CONCAT", category="JSON", description="Given N strings, parse them as JSON values and return a string representing their concatenation. Concatenation rules are identical to PostgreSQL's || operator:\n* If all strings deserialize into JSON objects, return an object with a union of the input keys. If there are duplicate objects, take values from the last object.\n* If all strings deserialize into JSON arrays, return the result of array concatenation.\n* If at least one of the deserialized values is not an object, convert non-array inputs to a single-element array and return the result of array concatenation.\n* If at least one of the input strings is `NULL` or can't be deserialized as JSON, return NULL.\nSimilar to the PostgreSQL's || operator, this function merges only top-level object keys or arrays.", author="Confluent")
public class JsonConcat {
    @Udf
    public String concat(String ... jsonStrings) {
        if (jsonStrings == null) {
            return null;
        }
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>(jsonStrings.length);
        boolean allObjects = true;
        for (String jsonString : jsonStrings) {
            if (jsonString == null) {
                return null;
            }
            JsonNode node = UdfJsonMapper.parseJson(jsonString);
            if (node.isMissingNode()) {
                return null;
            }
            if (allObjects && !node.isObject()) {
                allObjects = false;
            }
            nodes.add(node);
        }
        JsonNode result = (JsonNode)nodes.get(0);
        if (allObjects) {
            for (i = 1; i < nodes.size(); ++i) {
                result = this.concatObjects((ObjectNode)result, (ObjectNode)nodes.get(i));
            }
        } else {
            for (i = 1; i < nodes.size(); ++i) {
                result = this.concatArrays(this.toArrayNode(result), this.toArrayNode((JsonNode)nodes.get(i)));
            }
        }
        return UdfJsonMapper.writeValueAsJson(result);
    }

    private ObjectNode concatObjects(ObjectNode acc, ObjectNode node) {
        return (ObjectNode)acc.setAll(node);
    }

    private ArrayNode concatArrays(ArrayNode acc, ArrayNode node) {
        return acc.addAll(node);
    }

    private ArrayNode toArrayNode(JsonNode node) {
        if (node.isArray()) {
            return (ArrayNode)node;
        }
        return UdfJsonMapper.INSTANCE.createArrayNode().add(node);
    }
}

