/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import io.confluent.ksql.util.json.JsonPathTokenizer;
import java.util.Iterator;
import java.util.List;

@UdfDescription(name="extractjsonfield", category="JSON", description="Given a STRING that contains JSON data, extract the value at the specified  JSONPath or NULL if the specified path does not exist.")
public class JsonExtractString {
    private String latestPath = null;
    private List<String> latestTokens = null;

    @Udf
    public String extract(@UdfParameter(description="The input JSON string") String input, @UdfParameter(description="The JSONPath to extract") String path) {
        if (input == null || path == null) {
            return null;
        }
        if (this.latestPath == null || !this.latestPath.equals(path)) {
            JsonPathTokenizer tokenizer = new JsonPathTokenizer(path);
            this.latestTokens = ImmutableList.copyOf((Iterator)((Object)tokenizer));
            this.latestPath = path;
        }
        JsonNode currentNode = UdfJsonMapper.parseJson(input);
        for (String token : this.latestTokens) {
            if (currentNode instanceof ArrayNode) {
                try {
                    int index = Integer.parseInt(token);
                    currentNode = currentNode.get(index);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else {
                currentNode = currentNode.get(token);
            }
            if (currentNode != null) continue;
            return null;
        }
        if (currentNode.isTextual()) {
            return currentNode.asText();
        }
        return currentNode.toString();
    }
}

