/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import java.util.ArrayList;
import java.util.List;

@UdfDescription(name="JSON_ITEMS", category="JSON", description="Given a string with JSON array, converts it to a ksqlDB array of JSON strings. Returns `NULL` if the string can not be interpreted as a JSON array, for example, when the string is `NULL` or it does not contain valid JSON, or the JSON value is not an array.", author="Confluent")
public class JsonItems {
    @Udf
    public List<String> items(@UdfParameter String jsonItems) {
        if (jsonItems == null) {
            return null;
        }
        List<JsonNode> objectList = UdfJsonMapper.readAsJsonArray(jsonItems);
        ArrayList<String> res = new ArrayList<String>();
        objectList.forEach(jsonObject -> res.add(jsonObject.toString()));
        return res;
    }
}

