/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.confluent.ksql.function.KsqlFunctionException;
import java.util.List;

final class UdfJsonMapper {
    public static final ObjectMapper INSTANCE = new ObjectMapper().disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    private static final ObjectReader OBJECT_READER = INSTANCE.reader();

    private UdfJsonMapper() {
    }

    public static JsonNode parseJson(String jsonString) {
        try {
            return OBJECT_READER.readTree(jsonString);
        }
        catch (JacksonException e) {
            throw new KsqlFunctionException("Invalid JSON format:" + jsonString, (Throwable)e);
        }
    }

    public static String writeValueAsJson(Object obj) {
        try {
            return INSTANCE.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new KsqlFunctionException("JSON serialization error: " + e.getMessage());
        }
    }

    public static List<JsonNode> readAsJsonArray(String jsonString) {
        try {
            return (List)INSTANCE.readValue(jsonString, (TypeReference)new TypeReference<List<JsonNode>>(){});
        }
        catch (JsonProcessingException e) {
            throw new KsqlFunctionException("Invalid JSON format:" + jsonString, (Throwable)e);
        }
    }
}

