/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.map;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UdfDescription(name="AS_MAP", category="MAP", description="Construct a list based on some inputs", author="Confluent")
public class AsMap {
    @Udf
    public final <T> Map<String, T> asMap(@UdfParameter List<String> keys, @UdfParameter List<T> values) {
        if (keys == null || values == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            Object value = i >= values.size() ? null : (Object)values.get(i);
            map.put(key, value);
        }
        return map;
    }
}

