/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="atan", category="MATHEMATICAL", author="Confluent", description="The inverse (arc) tangent of a value. The returned value is in radians.")
public class Atan {
    @Udf(description="Returns the inverse (arc) tangent of an INT value")
    public Double atan(@UdfParameter(value="value", description="The value to get the inverse tangent of.") Integer value) {
        return this.atan(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) tangent of a BIGINT value")
    public Double atan(@UdfParameter(value="value", description="The value to get the inverse tangent of.") Long value) {
        return this.atan(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) tangent of a DOUBLE value")
    public Double atan(@UdfParameter(value="value", description="The value to get the inverse tangent of.") Double value) {
        return value == null ? null : Double.valueOf(Math.atan(value));
    }
}

