/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="cbrt", category="MATHEMATICAL", author="Confluent", description="The cube root of a value.")
public class Cbrt {
    @Udf(description="Returns the cube root of an INT value")
    public Double cbrt(@UdfParameter(value="value", description="The value to get the cube root of.") Integer value) {
        return this.cbrt(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cube root of a BIGINT value")
    public Double cbrt(@UdfParameter(value="value", description="The value to get the cube root of.") Long value) {
        return this.cbrt(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cube root of a DOUBLE value")
    public Double cbrt(@UdfParameter(value="value", description="The value to get the cube root of.") Double value) {
        return value == null ? null : Double.valueOf(Math.cbrt(value));
    }
}

