/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@UdfDescription(name="Ceil", category="MATHEMATICAL", description="Returns the smallest integer greater than or equal to the specified numeric expression.", author="Confluent")
public class Ceil {
    static final String DESCRIPTION = "Returns the smallest integer greater than or equal to the specified numeric expression.";

    @Udf
    public Integer ceil(@UdfParameter Integer val) {
        return val;
    }

    @Udf
    public Long ceil(@UdfParameter Long val) {
        return val;
    }

    @Udf
    public Double ceil(@UdfParameter Double val) {
        return val == null ? null : Double.valueOf(Math.ceil(val));
    }

    @Udf(schemaProvider="ceilDecimalProvider")
    public BigDecimal ceil(@UdfParameter BigDecimal val) {
        return val == null ? null : val.setScale(0, RoundingMode.CEILING).setScale(val.scale(), RoundingMode.UNNECESSARY);
    }

    @UdfSchemaProvider
    public SqlType ceilDecimalProvider(List<SqlArgument> params) {
        SqlType s = params.get(0).getSqlTypeOrThrow();
        if (s.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for Ceil expects a BigDecimal parametertype");
        }
        return s;
    }
}

