/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="cosh", category="MATHEMATICAL", author="Confluent", description="The hyperbolic cosine of a value.")
public class Cosh {
    @Udf(description="Returns the hyperbolic cosine of an INT value")
    public Double cosh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic cosine of.") Integer value) {
        return this.cosh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic cosine of a BIGINT value")
    public Double cosh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic cosine of.") Long value) {
        return this.cosh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic cosine of a DOUBLE value")
    public Double cosh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic cosine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.cosh(value));
    }
}

