/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="exp", category="MATHEMATICAL", author="Confluent", description="The exponential of a value.")
public class Exp {
    @Udf(description="Returns Euler's number e raised to the power of an INT value.")
    public Double exp(@UdfParameter(value="exponent", description="the exponent to raise e to.") Integer exponent) {
        return this.exp(exponent == null ? null : Double.valueOf(exponent.doubleValue()));
    }

    @Udf(description="Returns Euler's number e raised to the power of a BIGINT value.")
    public Double exp(@UdfParameter(value="exponent", description="the exponent to raise e to.") Long exponent) {
        return this.exp(exponent == null ? null : Double.valueOf(exponent.doubleValue()));
    }

    @Udf(description="Returns Euler's number e raised to the power of a DOUBLE value.")
    public Double exp(@UdfParameter(value="exponent", description="the exponent to raise e to.") Double exponent) {
        return exponent == null ? null : Double.valueOf(Math.exp(exponent));
    }
}

