/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@UdfDescription(name="Floor", category="MATHEMATICAL", description="Returns the largest integer less than or equal to the specified numeric expression.", author="Confluent")
public class Floor {
    static final String DESCRIPTION = "Returns the largest integer less than or equal to the specified numeric expression.";

    @Udf
    public Integer floor(@UdfParameter Integer val) {
        return val;
    }

    @Udf
    public Long floor(@UdfParameter Long val) {
        return val;
    }

    @Udf
    public Double floor(@UdfParameter Double val) {
        return val == null ? null : Double.valueOf(Math.floor(val));
    }

    @Udf(schemaProvider="floorDecimalProvider")
    public BigDecimal floor(@UdfParameter BigDecimal val) {
        return val == null ? null : val.setScale(0, RoundingMode.FLOOR).setScale(val.scale(), RoundingMode.UNNECESSARY);
    }

    @UdfSchemaProvider
    public SqlType floorDecimalProvider(List<SqlArgument> params) {
        SqlType s = params.get(0).getSqlTypeOrThrow();
        if (s.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for Floor expects a BigDecimal parametertype");
        }
        return s;
    }
}

