/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import com.google.common.collect.Streams;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@UdfDescription(name="greatest", category="MATHEMATICAL", description="Returns the highest non-null value among a variable number of comparable columns.", author="Confluent")
public class Greatest {
    @Udf
    public Integer greatest(@UdfParameter Integer val, Integer ... vals) {
        return vals == null ? null : (Integer)Stream.concat(Stream.of(val), Arrays.stream(vals)).filter(Objects::nonNull).max(Integer::compareTo).orElse(null);
    }

    @Udf
    public Long greatest(@UdfParameter Long val, Long ... vals) {
        return vals == null ? null : (Long)Stream.concat(Stream.of(val), Arrays.stream(vals)).filter(Objects::nonNull).max(Long::compareTo).orElse(null);
    }

    @Udf
    public Double greatest(@UdfParameter Double val, Double ... vals) {
        return vals == null ? null : (Double)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(Double::compareTo).orElse(null);
    }

    @Udf
    public String greatest(@UdfParameter String val, String ... vals) {
        return vals == null ? null : (String)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(String::compareTo).orElse(null);
    }

    @Udf
    public ByteBuffer greatest(@UdfParameter ByteBuffer val, ByteBuffer ... vals) {
        return vals == null ? null : (ByteBuffer)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(ByteBuffer::compareTo).orElse(null);
    }

    @Udf
    public Date greatest(@UdfParameter Date val, Date ... vals) {
        return vals == null ? null : (Date)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(java.util.Date::compareTo).orElse(null);
    }

    @Udf
    public Time greatest(@UdfParameter Time val, Time ... vals) {
        return vals == null ? null : (Time)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(java.util.Date::compareTo).orElse(null);
    }

    @Udf
    public Timestamp greatest(@UdfParameter Timestamp val, Timestamp ... vals) {
        return vals == null ? null : (Timestamp)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(Timestamp::compareTo).orElse(null);
    }

    @Udf(schemaProvider="greatestDecimalProvider")
    public BigDecimal greatest(@UdfParameter BigDecimal val, BigDecimal ... vals) {
        return vals == null ? null : (BigDecimal)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
    }

    @UdfSchemaProvider
    public SqlType greatestDecimalProvider(List<SqlArgument> params) {
        return params.stream().filter(s -> s.getSqlType().isPresent()).map(SqlArgument::getSqlTypeOrThrow).reduce(DecimalUtil::widen).orElse(null);
    }
}

