/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import com.google.common.collect.Streams;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@UdfDescription(name="least", category="MATHEMATICAL", description="Returns the lowest non-null value among a variable number of comparable columns", author="Confluent")
public class Least {
    @Udf
    public Integer least(@UdfParameter Integer val, Integer ... vals) {
        return vals == null ? null : (Integer)Stream.concat(Stream.of(val), Arrays.stream(vals)).filter(Objects::nonNull).min(Integer::compareTo).orElse(null);
    }

    @Udf
    public Long least(@UdfParameter Long val, Long ... vals) {
        return vals == null ? null : (Long)Stream.concat(Stream.of(val), Arrays.stream(vals)).filter(Objects::nonNull).min(Long::compareTo).orElse(null);
    }

    @Udf
    public Double least(@UdfParameter Double val, Double ... vals) {
        return vals == null ? null : (Double)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(Double::compareTo).orElse(null);
    }

    @Udf
    public String least(@UdfParameter String val, String ... vals) {
        return vals == null ? null : (String)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(String::compareTo).orElse(null);
    }

    @Udf
    public ByteBuffer least(@UdfParameter ByteBuffer val, ByteBuffer ... vals) {
        return vals == null ? null : (ByteBuffer)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(ByteBuffer::compareTo).orElse(null);
    }

    @Udf
    public Date least(@UdfParameter Date val, Date ... vals) {
        return vals == null ? null : (Date)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(java.util.Date::compareTo).orElse(null);
    }

    @Udf
    public Time least(@UdfParameter Time val, Time ... vals) {
        return vals == null ? null : (Time)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(java.util.Date::compareTo).orElse(null);
    }

    @Udf
    public Timestamp least(@UdfParameter Timestamp val, Timestamp ... vals) {
        return vals == null ? null : (Timestamp)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(Timestamp::compareTo).orElse(null);
    }

    @Udf(schemaProvider="leastDecimalProvider")
    public BigDecimal least(@UdfParameter BigDecimal val, BigDecimal ... vals) {
        return vals == null ? null : (BigDecimal)Streams.concat((Stream[])new Stream[]{Stream.of(val), Arrays.stream(vals)}).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    @UdfSchemaProvider
    public SqlType leastDecimalProvider(List<SqlArgument> params) {
        return params.stream().filter(s -> s.getSqlType().isPresent()).map(SqlArgument::getSqlTypeOrThrow).reduce(DecimalUtil::widen).orElse(null);
    }
}

