/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="sign", category="MATHEMATICAL", author="Confluent", description="The sign of a value.")
public class Sign {
    @Udf(description="Returns the sign of an INT value, denoted by 1, 0 or -1.")
    public Integer sign(@UdfParameter(value="value", description="The value to get the sign of.") Integer value) {
        return value == null ? null : Integer.valueOf(Integer.signum(value));
    }

    @Udf(description="Returns the sign of an BIGINT value, denoted by 1, 0 or -1.")
    public Integer sign(@UdfParameter(value="value", description="The value to get the sign of.") Long value) {
        return value == null ? null : Integer.valueOf(Long.signum(value));
    }

    @Udf(description="Returns the sign of an DOUBLE value, denoted by 1, 0 or -1.")
    public Integer sign(@UdfParameter(value="value", description="The value to get the sign of.") Double value) {
        return value == null ? null : Integer.valueOf((int)Math.signum(value));
    }
}

