/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="sqrt", category="MATHEMATICAL", author="Confluent", description="The square root of a value.")
public class Sqrt {
    @Udf(description="Returns the correctly rounded positive square root of a DOUBLE value")
    public Double sqrt(@UdfParameter(value="value", description="The value to get the square root of.") Integer value) {
        return this.sqrt(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the correctly rounded positive square root of a DOUBLE value")
    public Double sqrt(@UdfParameter(value="value", description="The value to get the square root of.") Long value) {
        return this.sqrt(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the correctly rounded positive square root of a DOUBLE value")
    public Double sqrt(@UdfParameter(value="value", description="The value to get the square root of.") Double value) {
        return value == null ? null : Double.valueOf(Math.sqrt(value));
    }
}

