/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="tan", category="MATHEMATICAL", author="Confluent", description="The tangent of a value.")
public class Tan {
    @Udf(description="Returns the tangent of an INT value")
    public Double tan(@UdfParameter(value="value", description="The value in radians to get the tangent of.") Integer value) {
        return this.tan(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the tangent of a BIGINT value")
    public Double tan(@UdfParameter(value="value", description="The value in radians to get the tangent of.") Long value) {
        return this.tan(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the tangent of a DOUBLE value")
    public Double tan(@UdfParameter(value="value", description="The value in radians to get the tangent of.") Double value) {
        return value == null ? null : Double.valueOf(Math.tan(value));
    }
}

