/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="tanh", category="MATHEMATICAL", author="Confluent", description="The hyperbolic tangent of a value.")
public class Tanh {
    @Udf(description="Returns the hyperbolic tangent of an INT value")
    public Double tanh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic tangent of.") Integer value) {
        return this.tanh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic tangent of a BIGINT value")
    public Double tanh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic tangent of.") Long value) {
        return this.tanh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic tangent of a DOUBLE value")
    public Double tanh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic tangent of.") Double value) {
        return value == null ? null : Double.valueOf(Math.tanh(value));
    }
}

