/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.nulls;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.name.FunctionName;

@UdfDescription(name="NULLIF", category="CONDITIONAL", description="Returns NULL if value1 and value2 are equal. Otherwise it returns value1.", author="Confluent")
public class NullIf {
    public static final String NAME_TEXT = "NULLIF";
    public static final FunctionName NAME = FunctionName.of((String)"NULLIF");

    @Udf
    public final <T> T nullIf(@UdfParameter(description="expression 1") T expr1, @UdfParameter(description="expression 2") T expr2) {
        if (expr1 == null) {
            return null;
        }
        if (expr1.equals(expr2)) {
            return null;
        }
        return expr1;
    }
}

