/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

@UdfDescription(name="concat", category="STRING", description="Concatenate an arbitrary number of string or bytes fields together")
public class Concat {
    @Udf
    public String concat(String ... inputs) {
        if (inputs == null) {
            return null;
        }
        return Arrays.stream(inputs).filter(Objects::nonNull).collect(Collectors.joining());
    }

    @Udf
    public ByteBuffer concat(ByteBuffer ... inputs) {
        if (inputs == null) {
            return null;
        }
        int capacity = 0;
        for (ByteBuffer bytes : inputs) {
            if (!Objects.nonNull(bytes)) continue;
            capacity += bytes.capacity();
        }
        ByteBuffer concatenated = ByteBuffer.allocate(capacity);
        Arrays.stream(inputs).filter(Objects::nonNull).forEachOrdered(concatenated::put);
        concatenated.rewind();
        return concatenated;
    }
}

