/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;

@UdfDescription(name="from_bytes", category="STRING", description="Converts a BYTES value to STRING in the specified encoding. The accepted encoders are 'hex', 'utf8', 'ascii', and 'base64'.", author="Confluent")
public class FromBytes {
    @Udf(description="Converts a BYTES value to STRING in the specified encoding. The accepted encoders are 'hex', 'utf8', 'ascii', and 'base64'.")
    public String fromBytes(@UdfParameter(description="The bytes value to convert.") ByteBuffer value, @UdfParameter(description="The encoding to use on conversion.") String encoding) {
        return value == null || encoding == null ? null : BytesUtils.encode((byte[])BytesUtils.getByteArray((ByteBuffer)value), (BytesUtils.Encoding)BytesUtils.Encoding.from((String)encoding));
    }
}

