/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UdfDescription(name="initcap", category="STRING", author="Confluent", description="Capitalizes the first letter of each word in a string and the rest lowercased. Words are delimited by whitespace.")
public class InitCap {
    @Udf(description="Returns the string with the the first letter of each word capitalized and the rest lowercased")
    public String initcap(@UdfParameter(description="The source string. If null, then function returns null.") String str) {
        if (str == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[^\\s]+\\s*");
        Matcher matcher = pattern.matcher(str.toLowerCase());
        String initCapped = "";
        while (matcher.find()) {
            String part = matcher.group();
            initCapped = initCapped.concat(part.substring(0, 1).toUpperCase() + part.substring(1));
        }
        return initCapped;
    }
}

