/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.util.KsqlException;

class Masker {
    private static final int DEFAULT_UPPERCASE_MASK = 88;
    private static final int DEFAULT_LOWERCASE_MASK = 120;
    private static final int DEFAULT_DIGIT_MASK = 110;
    private static final int DEFAULT_OTHER_MASK = 45;
    private static final int NO_MASK = Integer.MAX_VALUE;
    private int upperMask = 88;
    private int lowerMask = 120;
    private int digitMask = 110;
    private int otherMask = 45;

    Masker(int upperMask, int lowerMask, int digitMask, int otherMask) {
        this.upperMask = upperMask;
        this.lowerMask = lowerMask;
        this.digitMask = digitMask;
        this.otherMask = otherMask;
    }

    Masker() {
    }

    public String mask(String input) {
        StringBuilder output = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            output.appendCodePoint(this.maskCharacter(input.codePointAt(i)));
        }
        return output.toString();
    }

    private int maskCharacter(int c) {
        switch (Character.getType(c)) {
            case 1: {
                if (this.upperMask == Integer.MAX_VALUE) break;
                return this.upperMask;
            }
            case 2: {
                if (this.lowerMask == Integer.MAX_VALUE) break;
                return this.lowerMask;
            }
            case 9: {
                if (this.digitMask == Integer.MAX_VALUE) break;
                return this.digitMask;
            }
            default: {
                if (this.otherMask == Integer.MAX_VALUE) break;
                return this.otherMask;
            }
        }
        return c;
    }

    static int getMaskCharacter(String mask) {
        if (mask == null) {
            return Integer.MAX_VALUE;
        }
        if (mask.length() != 1) {
            throw new KsqlException("Invalid mask character. Must be only single character, but was '" + mask + "'");
        }
        return mask.codePointAt(0);
    }

    static void validateParams(String udfName, int numChars) {
        if (numChars < 0) {
            throw new KsqlFunctionException("function " + udfName + " requires a non-negative number of characters to mask or skip");
        }
    }
}

