/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

@UdfDescription(name="RPad", category="STRING", description="Pads the input string or bytes, starting from the end, with the specified padding string until the target length is reached. If the input string or bytes are longer than the specified target length it will be truncated. If the padding string or bytes are empty or NULL, or the target length is negative, then NULL is returned.")
public class RPad {
    @Udf
    public String rpad(@UdfParameter(description="String to be padded") String input, @UdfParameter(description="Target length") Integer targetLen, @UdfParameter(description="Padding string") String padding) {
        if (input == null) {
            return null;
        }
        if (padding == null || padding.isEmpty() || targetLen == null || targetLen < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(targetLen + padding.length());
        sb.append(input);
        int padChars = Math.max(targetLen - input.length(), 0);
        for (int i = 0; i < padChars; i += padding.length()) {
            sb.append(padding);
        }
        sb.setLength(targetLen);
        return sb.toString();
    }

    @Udf
    public ByteBuffer rpad(@UdfParameter(description="Bytes to be padded") ByteBuffer input, @UdfParameter(description="Target length") Integer targetLen, @UdfParameter(description="Padding bytes") ByteBuffer padding) {
        if (input == null) {
            return null;
        }
        if (padding == null || padding.capacity() == 0 || targetLen == null || targetLen < 0) {
            return null;
        }
        byte[] start = BytesUtils.getByteArray((ByteBuffer)input);
        if (start.length > targetLen) {
            return ByteBuffer.wrap(Arrays.copyOfRange(start, 0, (int)targetLen));
        }
        byte[] padded = new byte[targetLen.intValue()];
        byte[] paddingArray = BytesUtils.getByteArray((ByteBuffer)padding);
        System.arraycopy(start, 0, padded, 0, start.length);
        for (int i = start.length; i < targetLen; ++i) {
            int paddingIndex = (i - start.length) % paddingArray.length;
            padded[i] = paddingArray[paddingIndex];
        }
        return ByteBuffer.wrap(padded);
    }
}

