/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import com.google.common.base.Splitter;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@UdfDescription(name="split_to_map", category="STRING", description="Splits a string into key-value pairs and creates a map from them. The 'entryDelimiter' splits the string into key-value pairs which are then split by 'kvDelimiter'. If the same key is present multiple times in the input, the latest value for that key is returned. Returns NULL if the input text or either of the delimiters is NULL.")
public class SplitToMap {
    @Udf
    public Map<String, String> splitToMap(@UdfParameter(description="Separator string and values to join") String input, @UdfParameter(description="Separator string and values to join") String entryDelimiter, @UdfParameter(description="Separator string and values to join") String kvDelimiter) {
        if (input == null || entryDelimiter == null || kvDelimiter == null) {
            return null;
        }
        if (entryDelimiter.isEmpty() || kvDelimiter.isEmpty() || entryDelimiter.equals(kvDelimiter)) {
            return null;
        }
        Iterable entries = Splitter.on((String)entryDelimiter).omitEmptyStrings().split((CharSequence)input);
        return StreamSupport.stream(entries.spliterator(), false).filter(e -> e.contains(kvDelimiter)).map(kv -> Splitter.on((String)kvDelimiter).split((CharSequence)kv).iterator()).collect(Collectors.toMap(Iterator::next, Iterator::next, (v1, v2) -> v2));
    }
}

