/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.UUID;

@UdfDescription(name="UUID", category="STRING", description="Create a Universally Unique Identifier (UUID) generated according to RFC 4122. A call to UUID()\u00a0returns a value conforming to UUID version 4, sometimes called \"random UUID\", as described in RFC 4122. A call to UUID(bytes)\u00a0returns a value conforming to UUID. The value is a 128-bit number represented as a\u00a0string of five hexadecimal numbers aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee.")
public class Uuid {
    @Udf
    public String uuid() {
        return UUID.randomUUID().toString();
    }

    @Udf
    public String uuid(@UdfParameter ByteBuffer bytes) {
        if (bytes == null || bytes.capacity() != 16) {
            return null;
        }
        try {
            long firstLong = bytes.getLong();
            long secondLong = bytes.getLong();
            return new UUID(firstLong, secondLong).toString();
        }
        catch (BufferUnderflowException ex) {
            return null;
        }
    }
}

