/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.url;

import com.google.common.base.Splitter;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.url.UrlParser;
import java.net.URI;
import java.util.List;

@UdfDescription(name="url_extract_parameter", category="URL", description="Extracts a parameter with a specified name encoded inside an application/x-www-form-urlencoded String.", author="Confluent")
public class UrlExtractParameter {
    private static final Splitter PARAM_SPLITTER = Splitter.on((char)'&');
    private static final Splitter KV_SPLITTER = Splitter.on((char)'=').limit(2);

    @Udf
    public String extractParam(@UdfParameter(description="a valid URL") String input, @UdfParameter(description="the parameter key") String paramToFind) {
        String query = UrlParser.extract(input, URI::getQuery);
        if (query == null) {
            return null;
        }
        for (String param : PARAM_SPLITTER.split((CharSequence)query)) {
            List kvParam = KV_SPLITTER.splitToList((CharSequence)param);
            if (kvParam.size() == 1 && ((String)kvParam.get(0)).equals(paramToFind)) {
                return "";
            }
            if (kvParam.size() != 2 || !((String)kvParam.get(0)).equals(paramToFind)) continue;
            return (String)kvParam.get(1);
        }
        return null;
    }
}

