/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udtf.array;

import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.function.udtf.Udtf;
import io.confluent.ksql.function.udtf.UdtfDescription;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@UdtfDescription(name="explode", category="TABLE", author="Confluent", description="Explodes an array. This function outputs one value for each element of the array.")
public class Explode {
    @Udtf
    public <T> List<T> explode(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    @Udtf(schemaProvider="provideSchema")
    public List<BigDecimal> explodeBigDecimal(List<BigDecimal> input) {
        return this.explode(input);
    }

    @UdfSchemaProvider
    public SqlType provideSchema(List<SqlArgument> params) {
        SqlType argType = params.get(0).getSqlTypeOrThrow();
        if (!(argType instanceof SqlArray)) {
            throw new KsqlException("explode should be provided with an ARRAY");
        }
        return ((SqlArray)argType).getItemType();
    }
}

