/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.internal.KsqlMetric;
import io.confluent.ksql.internal.KsqlMetricsExtension;
import io.confluent.ksql.internal.QueryStateMetricsReportingListener;
import io.confluent.ksql.metrics.MetricCollectors;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.streams.KafkaStreams;

public class KsqlEngineMetrics
implements Closeable {
    private static final String DEFAULT_METRIC_GROUP_PREFIX = "ksql-engine";
    private static final String METRIC_GROUP_POST_FIX = "-query-stats";
    private final List<Sensor> sensors;
    private final List<CountMetric> countMetrics;
    private final String metricGroupPrefix;
    private final String metricGroupName;
    private final Sensor messagesIn;
    private final Sensor totalMessagesIn;
    private final Sensor totalBytesIn;
    private final Sensor messagesOut;
    private final Sensor numIdleQueries;
    private final Sensor messageConsumptionByQuery;
    private final Sensor errorRate;
    private final String ksqlServiceIdLegacyPrefix;
    private final String ksqlServicePrefix;
    private final Map<String, String> customMetricsTags;
    private final Map<String, String> newCustomMetricsTags;
    private final Optional<KsqlMetricsExtension> metricsExtension;
    private final KsqlEngine ksqlEngine;
    private final Metrics metrics;
    private final MetricCollectors metricCollectors;

    public KsqlEngineMetrics(String metricGroupPrefix, KsqlEngine ksqlEngine, Map<String, String> customMetricsTags, Optional<KsqlMetricsExtension> metricsExtension, MetricCollectors metricCollectors) {
        this(metricGroupPrefix.isEmpty() ? DEFAULT_METRIC_GROUP_PREFIX : metricGroupPrefix, ksqlEngine, metricCollectors, customMetricsTags, metricsExtension);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public KsqlEngineMetrics(String metricGroupPrefix, KsqlEngine ksqlEngine, MetricCollectors metricCollectors, Map<String, String> customMetricsTags, Optional<KsqlMetricsExtension> metricsExtension) {
        this.ksqlEngine = ksqlEngine;
        this.ksqlServiceIdLegacyPrefix = "_confluent-ksql-" + ksqlEngine.getServiceId();
        this.ksqlServicePrefix = "_confluent-";
        this.sensors = new ArrayList<Sensor>();
        this.countMetrics = new ArrayList<CountMetric>();
        this.metricGroupPrefix = Objects.requireNonNull(metricGroupPrefix, "metricGroupPrefix");
        this.metricGroupName = metricGroupPrefix + METRIC_GROUP_POST_FIX;
        this.customMetricsTags = customMetricsTags;
        this.newCustomMetricsTags = ImmutableMap.builder().putAll(customMetricsTags).put((Object)"ksql_service_id", (Object)ksqlEngine.getServiceId()).build();
        this.metricsExtension = metricsExtension;
        this.metrics = metricCollectors.getMetrics();
        this.metricCollectors = metricCollectors;
        this.configureLivenessIndicator();
        this.configureNumActiveQueries();
        this.configureNumPersistentQueries();
        this.messagesIn = this.configureMessagesIn();
        this.totalMessagesIn = this.configureTotalMessagesIn();
        this.totalBytesIn = this.configureTotalBytesIn();
        this.messagesOut = this.configureMessagesOut();
        this.numIdleQueries = this.configureIdleQueriesSensor();
        this.messageConsumptionByQuery = this.configureMessageConsumptionByQuerySensor();
        this.errorRate = this.configureErrorRate();
        Arrays.stream(KafkaStreams.State.values()).forEach(this::configureNumActiveQueriesForGivenState);
        this.configureCustomMetrics();
    }

    @Override
    public void close() {
        this.sensors.forEach(sensor -> this.metrics.removeSensor(sensor.name()));
        this.countMetrics.forEach(countMetric -> this.metrics.removeMetric(countMetric.getMetricName()));
    }

    public void updateMetrics() {
        this.recordMessagesConsumed(this.metricCollectors.currentConsumptionRate());
        this.recordTotalMessagesConsumed(this.metricCollectors.totalMessageConsumption());
        this.recordTotalBytesConsumed(this.metricCollectors.totalBytesConsumption());
        this.recordMessagesProduced(this.metricCollectors.currentProductionRate());
        this.recordMessageConsumptionByQueryStats(this.metricCollectors.currentConsumptionRateByQuery());
        this.recordErrorRate(this.metricCollectors.currentErrorRate());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public Metrics getMetrics() {
        return this.metrics;
    }

    List<Sensor> registeredSensors() {
        return this.sensors;
    }

    public QueryEventListener getQueryEventListener() {
        String metricsPrefix = this.metricGroupPrefix.equals(DEFAULT_METRIC_GROUP_PREFIX) ? "" : this.metricGroupPrefix;
        return new QueryStateMetricsReportingListener(this.metrics, metricsPrefix, this.newCustomMetricsTags);
    }

    private void recordMessageConsumptionByQueryStats(Collection<Double> messagesConsumedByQuery) {
        this.numIdleQueries.record((double)messagesConsumedByQuery.stream().filter(value -> value == 0.0).count());
        messagesConsumedByQuery.forEach(arg_0 -> ((Sensor)this.messageConsumptionByQuery).record(arg_0));
    }

    private void recordMessagesProduced(double value) {
        this.messagesOut.record(value);
    }

    private void recordMessagesConsumed(double value) {
        this.messagesIn.record(value);
    }

    private void recordTotalBytesConsumed(double value) {
        this.totalBytesIn.record(value);
    }

    private void recordTotalMessagesConsumed(double value) {
        this.totalMessagesIn.record(value);
    }

    private void recordErrorRate(double value) {
        this.errorRate.record(value);
    }

    private Sensor configureErrorRate() {
        String metricName = "error-rate";
        String description = "The number of messages which were consumed but not processed. Messages may not be processed if, for instance, the message contents could not be deserialized due to an incompatible schema. Alternately, a consumed messages may not have been produced, hence being effectively dropped. Such messages would also be counted toward the error rate.";
        return this.createSensor(KsqlMetric.of("error-rate", "The number of messages which were consumed but not processed. Messages may not be processed if, for instance, the message contents could not be deserialized due to an incompatible schema. Alternately, a consumed messages may not have been produced, hence being effectively dropped. Such messages would also be counted toward the error rate.", Value::new));
    }

    private Sensor configureMessagesOut() {
        String metricName = "messages-produced-per-sec";
        String description = "The number of messages produced per second across all queries";
        return this.createSensor(KsqlMetric.of("messages-produced-per-sec", "The number of messages produced per second across all queries", Value::new));
    }

    private Sensor configureMessagesIn() {
        String metricName = "messages-consumed-per-sec";
        String description = "The number of messages consumed per second across all queries";
        return this.createSensor(KsqlMetric.of("messages-consumed-per-sec", "The number of messages consumed per second across all queries", Value::new));
    }

    private Sensor configureTotalMessagesIn() {
        String metricName = "messages-consumed-total";
        String description = "The total number of messages consumed across all queries";
        return this.createSensor(KsqlMetric.of("messages-consumed-total", "The total number of messages consumed across all queries", Value::new));
    }

    private Sensor configureTotalBytesIn() {
        String metricName = "bytes-consumed-total";
        String description = "The total number of bytes consumed across all queries";
        return this.createSensor(KsqlMetric.of("bytes-consumed-total", "The total number of bytes consumed across all queries", Value::new));
    }

    private void configureNumActiveQueries() {
        String metricName = "num-active-queries";
        String description = "The current number of active queries running in this engine";
        Supplier<MeasurableStat> statSupplier = () -> new MeasurableStat(){

            public double measure(MetricConfig metricConfig, long l) {
                return KsqlEngineMetrics.this.ksqlEngine.numberOfLiveQueries();
            }

            public void record(MetricConfig metricConfig, double v, long l) {
            }
        };
        this.createSensor(KsqlMetric.of("num-active-queries", "The current number of active queries running in this engine", statSupplier));
    }

    private void configureNumPersistentQueries() {
        String metricName = "num-persistent-queries";
        String description = "The current number of persistent queries running in this engine";
        Supplier<MeasurableStat> statSupplier = () -> new MeasurableStat(){

            public double measure(MetricConfig metricConfig, long l) {
                return KsqlEngineMetrics.this.ksqlEngine.getPersistentQueries().size();
            }

            public void record(MetricConfig metricConfig, double v, long l) {
            }
        };
        this.createSensor(KsqlMetric.of("num-persistent-queries", "The current number of persistent queries running in this engine", statSupplier));
    }

    private Sensor configureIdleQueriesSensor() {
        String metricName = "num-idle-queries";
        String description = "Number of inactive queries";
        return this.createSensor(KsqlMetric.of("num-idle-queries", "Number of inactive queries", Value::new));
    }

    private void configureLivenessIndicator() {
        String metricName = "liveness-indicator";
        String description = "A metric with constant value 1 indicating the server is up and emitting metrics";
        Supplier<MeasurableStat> statSupplier = () -> new MeasurableStat(){

            public double measure(MetricConfig metricConfig, long l) {
                return 1.0;
            }

            public void record(MetricConfig metricConfig, double v, long l) {
            }
        };
        this.createSensor(KsqlMetric.of("liveness-indicator", "A metric with constant value 1 indicating the server is up and emitting metrics", statSupplier));
    }

    private Sensor configureMessageConsumptionByQuerySensor() {
        Sensor sensor = this.createSensor("message-consumption-by-query");
        this.configureMetric(sensor, KsqlMetric.of("messages-consumed-max", "max msgs consumed by query", Max::new));
        this.configureMetric(sensor, KsqlMetric.of("messages-consumed-min", "min msgs consumed by query", Min::new));
        this.configureMetric(sensor, KsqlMetric.of("messages-consumed-avg", "mean msgs consumed by query", Avg::new));
        return sensor;
    }

    private void configureMetric(Sensor sensor, KsqlMetric metric) {
        sensor.add(this.metrics.metricName(metric.name(), this.ksqlServiceIdLegacyPrefix + this.metricGroupName, metric.description(), this.customMetricsTags), metric.statSupplier().get());
        sensor.add(this.metrics.metricName(metric.name(), this.ksqlServicePrefix + this.metricGroupName, metric.description(), this.newCustomMetricsTags), metric.statSupplier().get());
    }

    private Sensor createSensor(String sensorName) {
        Sensor sensor = this.metrics.sensor(this.metricGroupName + "-" + sensorName);
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor createSensor(KsqlMetric metric) {
        Sensor sensor = this.createSensor(metric.name());
        this.configureMetric(sensor, metric);
        return sensor;
    }

    private void configureGaugeForState(String name, String group, Map<String, String> tags, KafkaStreams.State state) {
        Gauge gauge = (metricConfig, l) -> this.ksqlEngine.getPersistentQueries().stream().filter(queryMetadata -> queryMetadata.getState().equals((Object)state)).count();
        String description = String.format("Count of queries in %s state.", state.toString());
        MetricName metricName = this.metrics.metricName(name, group, description, tags);
        CountMetric countMetric = new CountMetric(metricName, (Gauge<Long>)gauge);
        try {
            this.metrics.addMetric(metricName, (MetricValueProvider)gauge);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.countMetrics.add(countMetric);
    }

    private void configureNumActiveQueriesForGivenState(KafkaStreams.State state) {
        String name = String.valueOf(state) + "-queries";
        this.configureGaugeForState(name, this.ksqlServiceIdLegacyPrefix + this.metricGroupName, this.customMetricsTags, state);
        this.configureGaugeForState(name, this.ksqlServicePrefix + this.metricGroupName, this.newCustomMetricsTags, state);
    }

    private void configureCustomMetrics() {
        if (!this.metricsExtension.isPresent()) {
            return;
        }
        List<KsqlMetric> customMetrics = this.metricsExtension.get().getCustomMetrics();
        customMetrics.forEach(this::createSensor);
    }

    private static class CountMetric {
        private final Gauge<Long> count;
        private final MetricName metricName;

        CountMetric(MetricName metricName, Gauge<Long> count) {
            Objects.requireNonNull(metricName, "Metric name cannot be null.");
            Objects.requireNonNull(count, "Count gauge cannot be null.");
            this.metricName = metricName;
            this.count = count;
        }

        MetricName getMetricName() {
            return this.metricName;
        }

        public Gauge<Long> getCount() {
            return this.count;
        }
    }
}

