/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

final class JoinTree {
    private JoinTree() {
    }

    public static Node build(List<Analysis.JoinInfo> joins) {
        Node root = null;
        for (Analysis.JoinInfo join : joins) {
            if (root == null) {
                root = new Leaf(join.getLeftSource());
            }
            if (root.containsSource(join.getRightSource()) && root.containsSource(join.getLeftSource())) {
                throw new KsqlException("Cannot perform circular join - both " + String.valueOf(join.getRightSource()) + " and " + String.valueOf(join.getLeftJoinExpression()) + " are already included in the current join tree: " + root.debugString(0));
            }
            if (root.containsSource(join.getLeftSource())) {
                root = new Join(root, new Leaf(join.getRightSource()), join);
                continue;
            }
            if (root.containsSource(join.getRightSource())) {
                root = new Join(root, new Leaf(join.getLeftSource()), join.flip());
                continue;
            }
            throw new KsqlException("Cannot build JOIN tree; neither source in the join is the FROM source or included in a previous JOIN: " + String.valueOf(join) + ". The current join tree is " + root.debugString(0));
        }
        return root;
    }

    static class Leaf
    implements Node {
        private final Analysis.AliasedDataSource source;

        Leaf(Analysis.AliasedDataSource source) {
            this.source = source;
        }

        public Analysis.AliasedDataSource getSource() {
            return this.source;
        }

        @Override
        public boolean containsSource(Analysis.AliasedDataSource dataSource) {
            return this.source.equals(dataSource);
        }

        @Override
        public String debugString(int indent) {
            return this.source.getAlias().toString(FormatOptions.noEscape());
        }

        @Override
        public Set<Expression> joinEquivalenceSet() {
            return ImmutableSet.of();
        }

        @Override
        public List<QualifiedColumnReferenceExp> viableKeyColumns() {
            return ImmutableList.of();
        }

        public String toString() {
            return "Leaf{source=" + String.valueOf(this.source) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Leaf that = (Leaf)o;
            return Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.source);
        }
    }

    static interface Node {
        public boolean containsSource(Analysis.AliasedDataSource var1);

        public String debugString(int var1);

        public Set<Expression> joinEquivalenceSet();

        public List<QualifiedColumnReferenceExp> viableKeyColumns();
    }

    static class Join
    implements Node {
        private final Node left;
        private final Node right;
        private final Analysis.JoinInfo info;

        Join(Node left, Node right, Analysis.JoinInfo info) {
            this.left = left;
            this.right = right;
            this.info = info;
        }

        public Analysis.JoinInfo getInfo() {
            return this.info;
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        @Override
        public boolean containsSource(Analysis.AliasedDataSource dataSource) {
            return this.left.containsSource(dataSource) || this.right.containsSource(dataSource);
        }

        @Override
        public String debugString(int indent) {
            return "\u22c8\n" + StringUtils.repeat((char)' ', (int)indent) + "+--" + this.left.debugString(indent + 3) + "\n" + StringUtils.repeat((char)' ', (int)indent) + "+--" + this.right.debugString(indent + 3);
        }

        @Override
        public Set<Expression> joinEquivalenceSet() {
            boolean includeRight;
            if (this.info.getType() == JoinNode.JoinType.OUTER) {
                return ImmutableSet.of();
            }
            ImmutableSet keys = ImmutableSet.of((Object)this.info.getLeftJoinExpression(), (Object)this.info.getRightJoinExpression());
            Set<Expression> lefts = this.left.joinEquivalenceSet();
            Set<Expression> rights = this.right.joinEquivalenceSet();
            boolean includeLeft = !Sets.intersection(lefts, (Set)keys).isEmpty();
            boolean bl = includeRight = !Sets.intersection(rights, (Set)keys).isEmpty();
            if (includeLeft && includeRight) {
                return Sets.union((Set)keys, (Set)Sets.union(lefts, rights));
            }
            if (includeLeft) {
                return Sets.union((Set)keys, lefts);
            }
            if (includeRight) {
                return Sets.union((Set)keys, rights);
            }
            return keys;
        }

        @Override
        public List<QualifiedColumnReferenceExp> viableKeyColumns() {
            if (this.info.getType() == JoinNode.JoinType.OUTER) {
                return ImmutableList.of();
            }
            Set<Expression> equiv = this.joinEquivalenceSet();
            return Streams.concat((Stream[])new Stream[]{this.left.viableKeyColumns().stream(), Stream.of(this.info.getLeftJoinExpression()), this.right.viableKeyColumns().stream(), Stream.of(this.info.getRightJoinExpression())}).filter(e -> e instanceof QualifiedColumnReferenceExp).map(QualifiedColumnReferenceExp.class::cast).distinct().filter(equiv::contains).collect(Collectors.toList());
        }

        public String toString() {
            return "Join{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", info=" + String.valueOf(this.info) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Join that = (Join)o;
            return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.info, that.info);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right, this.info);
        }
    }
}

