/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.util.ColumnExtractor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Immutable
public final class RequiredColumns {
    private final ImmutableSet<ColumnReferenceExp> requiredColumns;

    public static Builder builder() {
        return new Builder(new HashSet<ColumnReferenceExp>());
    }

    private RequiredColumns(Set<ColumnReferenceExp> requiredColumns) {
        this.requiredColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(requiredColumns, "requiredColumns"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="requiredColumns is ImmutableSet")
    public Collection<? extends ColumnReferenceExp> get() {
        return this.requiredColumns;
    }

    public Builder asBuilder() {
        return new Builder(new HashSet<ColumnReferenceExp>((Collection<ColumnReferenceExp>)this.requiredColumns));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredColumns that = (RequiredColumns)o;
        return Objects.equals(this.requiredColumns, that.requiredColumns);
    }

    public int hashCode() {
        return Objects.hash(this.requiredColumns);
    }

    public String toString() {
        return "RequiredColumns" + String.valueOf(this.requiredColumns);
    }

    public static final class Builder {
        private final Set<ColumnReferenceExp> requiredColumns;

        public Builder(Set<ColumnReferenceExp> requiredColumns) {
            this.requiredColumns = Objects.requireNonNull(requiredColumns, "requiredColumns");
        }

        public Builder add(Expression expression) {
            this.requiredColumns.addAll(ColumnExtractor.extractColumns((Expression)expression));
            return this;
        }

        public Builder addAll(Collection<? extends Expression> expressions) {
            expressions.forEach(this::add);
            return this;
        }

        public Builder remove(ColumnReferenceExp expression) {
            this.requiredColumns.remove(expression);
            return this;
        }

        public Builder removeAll(Collection<? extends ColumnReferenceExp> expressions) {
            expressions.forEach(this::remove);
            return this;
        }

        public RequiredColumns build() {
            return new RequiredColumns(this.requiredColumns);
        }
    }
}

