/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.analyzer.AggregateAnalysisResult;
import io.confluent.ksql.analyzer.AggregateExpressionRewriter;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.BytesLiteral;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.planner.plan.VerifiableNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.structured.SchemaKGroupedStream;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AggregateNode
extends SingleSourcePlanNode
implements VerifiableNode {
    private static final String INTERNAL_COLUMN_NAME_PREFIX = "KSQL_INTERNAL_COL_";
    private static final String PREPARE_OP_NAME = "Prepare";
    private static final String AGGREGATION_OP_NAME = "Aggregate";
    private static final String GROUP_BY_OP_NAME = "GroupBy";
    private static final String HAVING_FILTER_OP_NAME = "HavingFilter";
    private static final String PROJECT_OP_NAME = "Project";
    private final GroupBy groupBy;
    private final Optional<WindowExpression> windowExpression;
    private final ImmutableList<Expression> aggregateFunctionArguments;
    private final ImmutableList<FunctionCall> functionList;
    private final ImmutableList<ColumnReferenceExp> requiredColumns;
    private final Optional<Expression> havingExpressions;
    private final ImmutableList<SelectExpression> selectExpressions;
    private final ImmutableList<SelectExpression> finalSelectExpressions;
    private final ValueFormat valueFormat;
    private final LogicalSchema schema;
    private final KsqlConfig ksqlConfig;
    private final ExpressionTypeManager sourceTypeManager;

    public AggregateNode(PlanNodeId id, PlanNode source, LogicalSchema schema, GroupBy groupBy, FunctionRegistry functionRegistry, ImmutableAnalysis analysis, AggregateAnalysisResult rewrittenAggregateAnalysis, List<SelectExpression> projectionExpressions, boolean persistentQuery, KsqlConfig ksqlConfig, LogicalSchema sourceSchema) {
        super(id, DataSource.DataSourceType.KTABLE, Optional.empty(), source);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.groupBy = Objects.requireNonNull(groupBy, "groupBy");
        this.windowExpression = Objects.requireNonNull(analysis, "analysis").getWindowExpression();
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        AggregateExpressionRewriter aggregateExpressionRewriter = new AggregateExpressionRewriter(functionRegistry);
        this.aggregateFunctionArguments = ImmutableList.copyOf(rewrittenAggregateAnalysis.getAggregateFunctionArguments());
        this.functionList = ImmutableList.copyOf(rewrittenAggregateAnalysis.getAggregateFunctions());
        this.requiredColumns = ImmutableList.copyOf(rewrittenAggregateAnalysis.getRequiredColumns());
        this.selectExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(projectionExpressions, "projectionExpressions"));
        ImmutableSet groupings = ImmutableSet.copyOf((Collection)groupBy.getGroupingExpressions());
        this.finalSelectExpressions = ImmutableList.copyOf((Collection)projectionExpressions.stream().map(se -> SelectExpression.of((ColumnName)se.getAlias(), (Expression)ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((AggregateExpressionRewriter)aggregateExpressionRewriter).process(arg_0, arg_1), se.getExpression()))).filter(arg_0 -> AggregateNode.lambda$new$1(persistentQuery, (Set)groupings, arg_0)).collect(Collectors.toList()));
        this.havingExpressions = rewrittenAggregateAnalysis.getHavingExpression().map(exp -> ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((AggregateExpressionRewriter)aggregateExpressionRewriter).process(arg_0, arg_1), exp));
        this.valueFormat = this.getLeftmostSourceNode().getDataSource().getKsqlTopic().getValueFormat();
        this.sourceTypeManager = new ExpressionTypeManager(sourceSchema, functionRegistry);
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    public List<Expression> getGroupByExpressions() {
        return this.groupBy.getGroupingExpressions();
    }

    public Optional<WindowExpression> getWindowExpression() {
        return this.windowExpression;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        QueryContext.Stacker contextStacker = buildContext.buildNodeContext(this.getId().toString());
        SchemaKStream<?> sourceSchemaKStream = this.getSource().buildStream(buildContext);
        InternalSchema internalSchema = new InternalSchema((List<ColumnReferenceExp>)this.requiredColumns, (List<Expression>)this.aggregateFunctionArguments, buildContext.getFunctionRegistry(), this.sourceTypeManager);
        SchemaKStream<?> preSelected = this.selectRequiredInputColumns(sourceSchemaKStream, internalSchema, contextStacker, buildContext);
        SchemaKGroupedStream grouped = this.groupBy(contextStacker, preSelected);
        SchemaKTable<?> aggregated = this.aggregate(grouped, internalSchema, contextStacker);
        aggregated = this.applyHavingFilter(aggregated, contextStacker);
        return this.selectRequiredOutputColumns(aggregated, contextStacker, buildContext);
    }

    @Override
    public void validateKeyPresent(SourceName sinkName) {
        ArrayList missing = new ArrayList(this.groupBy.getGroupingExpressions());
        this.selectExpressions.stream().map(SelectExpression::getExpression).forEach(missing::remove);
        if (!missing.isEmpty()) {
            if (missing.contains(new BytesLiteral(ByteBuffer.wrap(new byte[]{1})))) {
                throw new KsqlException("CREATE TABLE AS SELECT statement does not support aggregate function " + String.valueOf(this.functionList) + " without a GROUP BY clause.");
            }
            AggregateNode.throwKeysNotIncludedError(sinkName, "grouping expression", missing);
        }
    }

    private SchemaKStream<?> selectRequiredInputColumns(SchemaKStream<?> sourceSchemaKStream, InternalSchema internalSchema, QueryContext.Stacker contextStacker, PlanBuildContext buildContext) {
        List<ColumnName> keyColumnNames = this.getSource().getSchema().key().stream().map(Column::name).collect(Collectors.toList());
        return sourceSchemaKStream.select(keyColumnNames, internalSchema.getAggArgExpansionList(), contextStacker.push(new String[]{PREPARE_OP_NAME}), buildContext, this.valueFormat.getFormatInfo());
    }

    private SchemaKTable<?> aggregate(SchemaKGroupedStream grouped, InternalSchema internalSchema, QueryContext.Stacker contextStacker) {
        List<FunctionCall> functions = internalSchema.updateFunctionList(this.functionList);
        QueryContext.Stacker aggregationContext = contextStacker.push(new String[]{AGGREGATION_OP_NAME});
        List<ColumnName> requiredColumnNames = this.requiredColumns.stream().map(e -> (UnqualifiedColumnReferenceExp)internalSchema.resolveToInternal((Expression)e)).map(ColumnReferenceExp::getColumnName).collect(Collectors.toList());
        return grouped.aggregate(requiredColumnNames, functions, this.windowExpression, this.valueFormat.getFormatInfo(), aggregationContext);
    }

    private SchemaKTable<?> applyHavingFilter(SchemaKTable<?> aggregated, QueryContext.Stacker contextStacker) {
        return this.havingExpressions.isPresent() ? aggregated.filter(this.havingExpressions.get(), contextStacker.push(new String[]{HAVING_FILTER_OP_NAME})) : aggregated;
    }

    private SchemaKStream<?> selectRequiredOutputColumns(SchemaKTable<?> aggregated, QueryContext.Stacker contextStacker, PlanBuildContext buildContext) {
        List keyColumnNames = this.getSchema().key().stream().map(Column::name).collect(Collectors.toList());
        return aggregated.select(keyColumnNames, (List)this.finalSelectExpressions, contextStacker.push(new String[]{PROJECT_OP_NAME}), buildContext, this.valueFormat.getFormatInfo());
    }

    private SchemaKGroupedStream groupBy(QueryContext.Stacker contextStacker, SchemaKStream<?> preSelected) {
        return preSelected.groupBy(this.valueFormat.getFormatInfo(), this.groupBy.getGroupingExpressions(), contextStacker.push(new String[]{GROUP_BY_OP_NAME}));
    }

    private static /* synthetic */ boolean lambda$new$1(boolean persistentQuery, Set groupings, SelectExpression e) {
        return !persistentQuery || !groupings.contains(e.getExpression());
    }

    private static class InternalSchema {
        private final List<SelectExpression> aggArgExpansions = new ArrayList<SelectExpression>();
        private final Map<String, ColumnName> expressionToInternalColumnName = new HashMap<String, ColumnName>();
        private final FunctionRegistry functionRegistry;
        private final ExpressionTypeManager sourceTypeManager;

        InternalSchema(List<ColumnReferenceExp> requiredColumns, List<Expression> aggregateFunctionArguments, FunctionRegistry functionRegistry, ExpressionTypeManager sourceTypeManager) {
            this.collectAggregateArgExpressions(requiredColumns);
            this.collectAggregateArgExpressions(aggregateFunctionArguments);
            this.functionRegistry = functionRegistry;
            this.sourceTypeManager = sourceTypeManager;
        }

        private void collectAggregateArgExpressions(Collection<? extends Expression> expressions) {
            for (Expression expression : expressions) {
                String sql = expression.toString();
                if (this.expressionToInternalColumnName.containsKey(sql)) continue;
                ColumnName internalName = expression instanceof ColumnReferenceExp ? ((ColumnReferenceExp)expression).getColumnName() : ColumnName.of((String)(AggregateNode.INTERNAL_COLUMN_NAME_PREFIX + this.aggArgExpansions.size()));
                this.aggArgExpansions.add(SelectExpression.of((ColumnName)internalName, (Expression)expression));
                this.expressionToInternalColumnName.put(sql, internalName);
            }
        }

        List<Expression> updateArgsExpressionList(FunctionName functionName, List<Expression> params) {
            if (params.isEmpty()) {
                return ImmutableList.of();
            }
            int numInitArgs = this.functionRegistry.getAggregateFactory((FunctionName)functionName).getFunction(params.stream().map((Function<Expression, SqlType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpressionSqlType(io.confluent.ksql.execution.expression.tree.Expression ), (Lio/confluent/ksql/execution/expression/tree/Expression;)Lio/confluent/ksql/schema/ksql/types/SqlType;)((ExpressionTypeManager)this.sourceTypeManager)).collect(Collectors.toList())).initArgs;
            int numColArgs = params.size() - numInitArgs;
            ArrayList<Expression> internalParams = new ArrayList<Expression>(params.size());
            internalParams.addAll(params.subList(0, numColArgs).stream().map(this::resolveToInternal).collect(Collectors.toList()));
            internalParams.addAll(params.subList(numColArgs, params.size()));
            return internalParams;
        }

        List<FunctionCall> updateFunctionList(ImmutableList<FunctionCall> functions) {
            return functions.stream().map(fc -> new FunctionCall(fc.getName(), this.updateArgsExpressionList(fc.getName(), fc.getArguments()))).collect(Collectors.toList());
        }

        List<SelectExpression> getAggArgExpansionList() {
            return this.aggArgExpansions;
        }

        private Expression resolveToInternal(Expression exp) {
            ColumnName name = this.expressionToInternalColumnName.get(exp.toString());
            if (name != null) {
                return new UnqualifiedColumnReferenceExp(exp.getLocation(), name);
            }
            return ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((ResolveToInternalRewriter)new ResolveToInternalRewriter()).process(arg_0, arg_1), exp);
        }

        private final class ResolveToInternalRewriter
        extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
            private ResolveToInternalRewriter() {
                super(Optional.empty());
            }

            public Optional<Expression> visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<Void> context) {
                ColumnName name = InternalSchema.this.expressionToInternalColumnName.get(node.toString());
                if (name != null) {
                    return Optional.of(new UnqualifiedColumnReferenceExp(node.getLocation(), name));
                }
                boolean isAggregate = ColumnNames.isAggregate((ColumnName)node.getColumnName());
                boolean windowBounds = SystemColumns.isWindowBound((ColumnName)node.getColumnName());
                if (isAggregate && windowBounds) {
                    throw new KsqlException("Window bound " + String.valueOf(node) + " is not available as a parameter to aggregate functions");
                }
                if (!isAggregate && !windowBounds) {
                    throw new KsqlException("Unknown source column: " + String.valueOf(node));
                }
                return Optional.of(node);
            }
        }
    }
}

