/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.Objects;

public class FilterNode
extends SingleSourcePlanNode {
    private final Expression predicate;

    public FilterNode(PlanNodeId id, PlanNode source, Expression predicate) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    @Override
    public LogicalSchema getSchema() {
        return this.getSource().getSchema();
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext builderContext) {
        QueryContext.Stacker contextStacker = builderContext.buildNodeContext(this.getId().toString());
        return this.getSource().buildStream(builderContext).filter(this.getPredicate(), contextStacker);
    }
}

